<?php
/**
 * Plugin Name:       Content Upgrades
 * Description:       Not another WordPress email opt-in plugin. It's a powerful list building machine.
 * Version: 2.0.6
 * Author:            iThemes
 * Author URI:        https://ithemes.com/
 * Text Domain:       aops-content-upgrades
 * License:           GPL-2.0+
 * License URI:       http://www.gnu.org/licenses/gpl-2.0.txt
 * iThemes Package:   content-upgrades
 */

/*  This program is free software; you can redistribute it and/or modify
	it under the terms of the GNU General Public License, version 2, as
	published by the Free Software Foundation.

	This program is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.
*/

require_once 'includes.php';


if ( ! defined( 'AOPS_CU_VERSION' ) ) {
	define('AOPS_CU_VERSION', '2.0.6');
}

if ( ! defined( 'WPINC' ) ) {
	die;
}

if( !class_exists( 'DOMDocument' ) ) {
	define('AOPS_USE_DOM_DOCUMENT', false );
} else {
	define('AOPS_USE_DOM_DOCUMENT', true );
}

$pluginRoot = __FILE__;

register_activation_hook( $pluginRoot, array('AopsContentUpgrades', 'install' ) );

if ( is_admin() ) {

	/**** Initialise Plugin ****/
	$aopsContentUpgrades = new AopsContentUpgrades( $pluginRoot );

	/**** Initialise Settings Page ****/
	$aopsSettingsPage = new AopsSettingsPage();

	/**** Load remaining classes ****/
	aops_initialize_other_classes( $pluginRoot );
} else {
	/**** Check whether to initialize  ****/
	add_action( 'wp', 'aops_check_initialization', 100 );
}

function aops_check_initialization() {

	if ( is_front_page() || is_home() ) { // specifically check whether needed on the main page to reduce the load
		$initialize = get_option( 'aops_cu_load_cu_main_page' );
	} else {
		$initialize = true;
	}

	if ( $initialize ) {

		$pluginRoot = __FILE__;

		/**** Initialise Plugin ****/
		$aopsContentUpgrades = new AopsContentUpgrades( $pluginRoot );

		aops_initialize_other_classes( $pluginRoot );
	}
}

function aops_initialize_other_classes( $pluginRoot ) {

	if ( is_admin() ) {

		/**** Initialise Tabs on "Edit Content Upgrade" page ****/
		$aopsContentUpgradeTabs = new AopsContentUpgradeTabs($pluginRoot);

		/**** Initialise Entries Page ****/
		$aopsEntriesPage = new AopsEntriesPage();

		/**** Initialise Analytics Page ****/
		$aopsAnalyticsPage = new AopsAnalyticsPage();

		/**** Initialise CSV generator ****/
		if (isset($_GET['generate_aops_csv']) && $_GET['generate_aops_csv'] == 1) {
			$aopsCsvExport = new AopsEntriesCsvExport();
			$aopsCsvExport->generate();
			exit();
		}

		if (isset($_GET['test_aops_log']) && $_GET['test_aops_log'] == 1) {
			$aopsContentUpgrades::log('test');
		}
	}

	/**** Drip Integration ****/
	$aopsDripIntegration = new AopsDripIntegration();					// sets 'admin_init' and 'wp_footer' actions when constructed

	/**** Convertkit Integration ****/
	$aopsConvertkitIntegration = new AopsConvertkitIntegration();		// sets an action for "admin_init" when constructed

	/**** Mailchimp Integration ****/
	$aopsMailchimpIntegration = new AopsMailchimpIntegration();			// sets 2 actions for "admin_init" when constructed

	/**** Zapier Integration ****/
	$aopsZapierIntegration = new AopsZapierIntegration();				// sets an action for "template_redirect" when constructed
}

function ithemes_content_upgrades_updater_register( $updater ) { 
	$updater->register( 'content-upgrades', __FILE__ );
}
add_action( 'ithemes_updater_register', 'ithemes_content_upgrades_updater_register' );

require( dirname( __FILE__ ) . '/lib/updater/load.php' );
